﻿-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
-- Script:  Refuel
-- Version: 1.1
-- Build:   2014-05-11
-- By:      oe3gsu@x-plane.at
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
-- Description:
-- Allows Refuelling of your airplane
-- Usable in all planes
-- Refueling or Defueling only if:
--    Aircraft is not moving
--    All Engines are off
--    Pilot is in the cockpit
-- Refueling or Defueling stops if tanks are full resp. empty
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --


-- STARTUP -----------------------------------------------------------------

require("graphics")

add_macro("Fuel", "FUEL_window_on = true", "FUEL_window_on = false", "deactivate")

dataref("FUEL_xp_fuel_akt", "sim/flightmodel/weight/m_fuel_total")
dataref("FUEL_xp_fuel_max", "sim/aircraft/weight/acf_m_fuel_tot")
dataref("FUEL_xp_groundspeed", "sim/flightmodel/position/groundspeed")
dataref("FUEL_xp_eng_count", "sim/aircraft/engine/acf_num_engines")
FUEL_xp_engine_run = dataref_table("sim/flightmodel/engine/ENGN_running")

FUEL_xp_tanks = dataref_table("sim/flightmodel/weight/m_fuel", "writable")
FUEL_tank_rate = dataref_table("sim/aircraft/overflow/acf_tank_rat")          -- 0.0 if not used

dataref("FUEL_xp_view_ext", "sim/graphics/view/view_is_external")
dataref("FUEL_xp_fuel_1", "sim/flightmodel/weight/m_fuel1", "writable")
dataref("FUEL_xp_fuel_2", "sim/flightmodel/weight/m_fuel2", "writable")
dataref("FUEL_xp_fuel_3", "sim/flightmodel/weight/m_fuel3", "writable")

local window_w = 390    -- Fenster Breite
local window_h = 120    -- Fenster Höhe
local window_x = 0      -- Position links unten X
local window_y = 0      -- Position links unten 
local X_offset = 0      -- Differenz zu Mitte X
local Y_offset = 0      -- Differenz zu Mitte X
local X_Mouse0 = 0      -- Maus Position bei Klick im Kreuz X
local Y_Mouse0 = 0      -- Maus Position bei Klick im Kreuz Y
local window_move = false
local FUEL_fuel_akt = 0
local FUEL_fuel_req = FUEL_xp_fuel_akt
local FUEL_run = false
local FUEL_any_eng_run = 0
local show_in_kg = true
local message_string = ""
local message_end = 0
local message_time = 5
local refuel_time = 3
local Fuel_per_min = (FUEL_xp_fuel_max/(refuel_time * 60))
    local C = 0
    for i = 0, 8 do
      if FUEL_tank_rate[i] > 0 then
        C = C + 1
      end
    end

local fuel_debug = false

function FUEL_show_window()
  if FUEL_window_on == false or FUEL_xp_view_ext > 0 then return end
    if window_move == true then
      X_offset = MOUSE_X - X_Mouse0
      Y_offset = MOUSE_Y - Y_Mouse0
    end

    XPLMSetGraphicsState(0,0,0,1,1,0,0)

  
  window_x = SCREEN_WIDTH / 2 - window_w / 2 + X_offset
  window_y = SCREEN_HIGHT / 2 - window_h / 2 + Y_offset
  graphics.set_color(0.5, 0.5, 0.5, 0.8)    
  graphics.draw_rectangle(window_x, window_y, window_x + window_w, window_y + window_h)
  graphics.set_color(1.0, 1.0, 1.0, 1.0)    
  graphics.set_width(1)
  graphics.draw_line(window_x, window_y, window_x, window_y + window_h)                       -- links
  graphics.draw_line(window_x, window_y + window_h, window_x + window_w, window_y + window_h) -- oben
  graphics.draw_line(window_x + window_w, window_y + window_h, window_x + window_w, window_y) -- rechts
  graphics.draw_line(window_x, window_y, window_x + window_w, window_y)                       -- unten
  graphics.set_color(0.9, 0.2, 0.2, 0.8)    
  graphics.draw_rectangle(window_x, window_y+100, window_x + 20, window_y + 119)
  graphics.set_color(1.0, 1.0, 1.0, 1.0)    
  graphics.draw_line(window_x+10, window_y+105, window_x+10, window_y+115)                       -- senkrecht
  graphics.draw_line(window_x+5, window_y+110, window_x + 15, window_y+110)                       -- waagrecht
  
  graphics.set_color(0.1, 0.1, 0.1, 1.0) ------------------------------------------------------- Instrument
  graphics.draw_filled_circle(window_x + 60, window_y + 60, 55)
  graphics.set_color(1.0, 1.0, 1.0, 1.0)    
  graphics.draw_arc(window_x + 60, window_y + 60, -140, 140, 55)
  for tick_angle = -120, 120, 20 do
    graphics.draw_tick_mark(window_x + 60, window_y + 60, tick_angle, 55, 6, 1)
  end
  
  graphics.set_color(0.1, 0.1, 0.1, 1.0) ------------------------------------------------------- Anzeige loaded, Request, Message
  graphics.draw_rectangle(window_x+130, window_y+80, window_x + 240, window_y + 110)  -- loaded
  graphics.draw_rectangle(window_x+130, window_y+40, window_x + 240, window_y + 70)   -- request
  graphics.draw_rectangle(window_x+130, window_y+10, window_x + 380, window_y + 30)   -- Message
  graphics.set_color(0.0, 0.9, 0.0, 1.0)
  graphics.draw_rectangle(window_x+320, window_y+80, window_x + 380, window_y + 100)   -- Start
  graphics.set_color(0.9, 0.0, 0.0, 1.0)
  graphics.draw_rectangle(window_x+320, window_y+50, window_x + 380, window_y + 70)   -- Stop
  graphics.set_color(1.0, 1.0, 1.0, 1.0)    
  draw_string_Helvetica_12(window_x+243, window_y+90, "Fuel loaded")
  draw_string_Helvetica_12(window_x+243, window_y+50, "Fuel request")
  draw_string_Helvetica_12(window_x+337, window_y+85, "Start")
  draw_string_Helvetica_12(window_x+337, window_y+55, "Stop")

  draw_string_Helvetica_12(window_x+22, window_y+25, "E")
  draw_string_Helvetica_12(window_x+90, window_y+25, "F")
  draw_string_Helvetica_12(window_x+15, window_y+70, "1/4")
  draw_string_Helvetica_12(window_x+50, window_y+95, "1/2")
  draw_string_Helvetica_12(window_x+90, window_y+70, "3/4")
  
-- dataref("FUEL_xp_fuel_akt", "sim/flightmodel/weight/m_fuel_total")    Menge im Tank [kg]
-- dataref("FUEL_xp_fuel_max", "sim/aircraft/weight/acf_m_fuel_tot")     Maximale Tankmenge [kg]
-- kg * 2.2046 = lb 
-- lb * 0.4536 = kg  
  if show_in_kg == true then
    FUEL_fuel_akt = FUEL_xp_fuel_akt
    draw_string_Helvetica_18(window_x+138, window_y+88, string.format("%6.0f", FUEL_fuel_akt)) ----------------Display Fuel loaded
    draw_string_Helvetica_18(window_x+138, window_y+48, string.format("%6.0f", FUEL_fuel_req)) ----------------Display Fuel loaded
    draw_string_Helvetica_18(window_x+210, window_y+88, "kg")
    draw_string_Helvetica_18(window_x+210, window_y+48, "kg")
  else
    FUEL_fuel_akt = FUEL_xp_fuel_akt * 2.2046
    draw_string_Helvetica_18(window_x+138, window_y+88, string.format("%6.0f", FUEL_fuel_akt)) ----------------Display Fuel loaded
    draw_string_Helvetica_18(window_x+138, window_y+48, string.format("%6.0f", FUEL_fuel_req * 2.2046)) ----------------Display Fuel loaded
    draw_string_Helvetica_18(window_x+210, window_y+88, "lb")
    draw_string_Helvetica_18(window_x+210, window_y+48, "lb")
  end
  graphics.set_color(1.0, 1.0, 0.0, 1.0)    
  graphics.draw_angle_arrow(window_x + 60, window_y + 60, (FUEL_xp_fuel_akt/FUEL_xp_fuel_max*280)-140, 55, 15, 4) -------Display Arrow
  graphics.set_color(1.0, 0.0, 0.0, 1.0)    
  graphics.draw_angle_arrow(window_x + 60, window_y + 60, (FUEL_fuel_req/FUEL_xp_fuel_max*280)-140, 55, 5, 1) -------Display Arrow
  graphics.set_color(0.8, 0.8, 0.8, 1.0)    
  graphics.draw_filled_circle(window_x + 60, window_y + 60, 10)
  graphics.set_color(1.0, 1.0, 1.0, 1.0)    
  
  
  
  if string.len(message_string) < 1 then   ------------------------------------------------------------------------------- Show Message
    draw_string_Helvetica_12(window_x+140, window_y+15, "  FUEL-Script V2.1 oe3gsu@x-plane.at")
    message_end = os.clock() + message_time
  else
    draw_string_Helvetica_12(window_x+140, window_y+15, message_string)
    if os.clock() > message_end then message_string = "" end
  end
  
  if MOUSE_X > window_x+320 and MOUSE_X < window_x + 380 and MOUSE_Y > window_y+80 and MOUSE_Y < window_y + 100 then ---- Show mouse in Start
    graphics.set_color(0.0, 0.6, 0.0, 1.0)
    graphics.draw_rectangle(window_x+320, window_y+80, window_x + 380, window_y + 100)   -- Start
    graphics.set_color(1.0, 1.0, 1.0, 1.0)    
    draw_string_Helvetica_12(window_x+337, window_y+85, "Start")
  end
  if MOUSE_X > window_x+320 and MOUSE_X < window_x + 380 and MOUSE_Y > window_y+50 and MOUSE_Y < window_y + 70 then ---- Show mouse in Start
    graphics.set_color(0.6, 0.0, 0.0, 1.0)
    graphics.draw_rectangle(window_x+320, window_y+50, window_x + 380, window_y + 70)   -- Stop
    graphics.set_color(1.0, 1.0, 1.0, 1.0)    
    draw_string_Helvetica_12(window_x+337, window_y+55, "Stop")
  end
  
  
  if fuel_debug == true then
    graphics.set_color(1.0, 1.0, 1.0, 1.0)    
    draw_string_Helvetica_12(window_x+400, window_y+120, string.format("%.1f", FUEL_xp_fuel_max) .. "  FUEL_xp_fuel_max / max")
    draw_string_Helvetica_12(window_x+400, window_y+100, string.format("%.1f", FUEL_xp_fuel_akt) .. "  FUEL_xp_fuel_akt   / akt")
    draw_string_Helvetica_12(window_x+400, window_y+80, string.format("%.1f", FUEL_fuel_req) .. "  FUEL_fuel_req   / req")
    draw_string_Helvetica_12(window_x+400, window_y+60, Fuel_per_min .. "  Fuel_per_min")
    draw_string_Helvetica_12(window_x+400, window_y+40, C .. "  C")
--    draw_string_Helvetica_12(window_x+400, window_y+20, i .. "  i")
    --draw_string_Helvetica_12(window_x+400, window_y+0, MOUSE_X .. "  MOUSE_X")
    --draw_string_Helvetica_12(window_x+400, window_y-20, MOUSE_Y .. "  MOUSE_X")
   
  end
  
end

do_every_draw("FUEL_show_window()")


function FUEL_main() ----------------------------------------------------------------------------------------------- MAIN
  if FUEL_window_on ~= true then return end
  if FUEL_run == true then
    if FUEL_xp_groundspeed > 0.3 then 
      message_string = "   AIRCRAFT IS MOVING"
      FUEL_run = false
    end
    
    local i
    for i = 0, FUEL_xp_eng_count do
      if FUEL_xp_engine_run[i] > 0 then 
        FUEL_any_eng_run = 1
      end
    end
    if FUEL_any_eng_run > 0 then 
      message_string = "   any ENGINE is running"
      FUEL_run = false
      FUEL_any_eng_run = 0
    end 
    
    
    if FUEL_run == true then
      if math.abs(FUEL_xp_fuel_akt - FUEL_fuel_req) < Fuel_per_min then 
        FUEL_run = false 
          FUEL_xp_fuel_1 = FUEL_xp_fuel_1 + (FUEL_fuel_req - FUEL_xp_fuel_akt) / C 
          FUEL_xp_fuel_2 = FUEL_xp_fuel_2 + (FUEL_fuel_req - FUEL_xp_fuel_akt) / C 
          FUEL_xp_fuel_3 = FUEL_xp_fuel_3 + (FUEL_fuel_req - FUEL_xp_fuel_akt) / C 
      else
        if FUEL_xp_fuel_akt < FUEL_fuel_req then
          FUEL_xp_fuel_1 = FUEL_xp_fuel_1 + (Fuel_per_min / C)
          FUEL_xp_fuel_2 = FUEL_xp_fuel_2 + (Fuel_per_min / C)
          FUEL_xp_fuel_3 = FUEL_xp_fuel_3 + (Fuel_per_min / C)
        else
          FUEL_xp_fuel_1 = FUEL_xp_fuel_1 - (Fuel_per_min / C)
          FUEL_xp_fuel_2 = FUEL_xp_fuel_2 - (Fuel_per_min / C)
          FUEL_xp_fuel_3 = FUEL_xp_fuel_3 - (Fuel_per_min / C)
        end
      end
    end
  end
  
end

do_often("FUEL_main()")


function FUEL_mouse_click_events() --------------------------------------------------------------------------------- Mouse Click -----------
  if FUEL_window_on ~= true then return end
  if MOUSE_STATUS == "down" and MOUSE_X > window_x+130 and MOUSE_X < window_x+240 and MOUSE_Y < window_y+110 and MOUSE_Y > window_y+80 then --------------Click in "Fuel loaded"
    show_in_kg = not show_in_kg
    RESUME_MOUSE_CLICK = true
  elseif MOUSE_STATUS == "down" and MOUSE_X > window_x+320 and MOUSE_X < window_x+380 and MOUSE_Y < window_y+110 and MOUSE_Y > window_y+80 then ----------Click in Start
    FUEL_run = true
    RESUME_MOUSE_CLICK = true
  elseif MOUSE_STATUS == "down" and MOUSE_X > window_x+320 and MOUSE_X < window_x+380 and MOUSE_Y < window_y+70 and MOUSE_Y > window_y+50 then ----------Click in Start
    FUEL_run = false
    RESUME_MOUSE_CLICK = true
  
  elseif MOUSE_STATUS == "down" and MOUSE_X > window_x+0 and MOUSE_X < window_x+20 and MOUSE_Y < window_y+120 and MOUSE_Y > window_y+100 then ----------Click in MOVE
    if window_move == false then
      X_Mouse0 = MOUSE_X - X_offset
      Y_Mouse0 = MOUSE_Y- Y_offset
      window_move = true
    else
      window_move = false
    end
  end

end

do_on_mouse_click("FUEL_mouse_click_events()")

function FUEL_mouse_wheel_events()  --------------------------------------------------------------------------------- Mouse Click -----------
  if FUEL_window_on ~= true then return end
  if MOUSE_X > window_x+130 and MOUSE_X < window_x+160 and MOUSE_Y < window_y+70 and MOUSE_Y > window_y+40 then ---------------- Requ. Fuel 1000
    if FUEL_xp_fuel_max > 1000 then
      FUEL_fuel_req = FUEL_fuel_req + (MOUSE_WHEEL_CLICKS*1000)
    else
      FUEL_fuel_req = FUEL_fuel_req + (MOUSE_WHEEL_CLICKS*100)
    end
    RESUME_MOUSE_WHEEL = true
  end
  if MOUSE_X > window_x+160 and MOUSE_X < window_x+200 and MOUSE_Y < window_y+70 and MOUSE_Y > window_y+40 then ---------------- Requ. Fuel 100
    if FUEL_xp_fuel_max > 1000 then
      FUEL_fuel_req = FUEL_fuel_req + (MOUSE_WHEEL_CLICKS*100)
    else
       FUEL_fuel_req = FUEL_fuel_req + (MOUSE_WHEEL_CLICKS*10)
   end
    RESUME_MOUSE_WHEEL = true
  end
  if FUEL_fuel_req < 0 then FUEL_fuel_req = 0 end
  if FUEL_fuel_req > FUEL_xp_fuel_max then FUEL_fuel_req = FUEL_xp_fuel_max end
end

do_on_mouse_wheel("FUEL_mouse_wheel_events()")

create_command("FlyWithLua/Fuel/toggle_fuel", "Toggle Fuel", "FUEL_window_on = not FUEL_window_on", "", "")

